#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
using gov.va.med.vbecs.DAL.HL7AL;
//-----------------------***
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;
#endregion

namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_VbecsHL7Bridge : BaseTest
	{
		private const string TAS_TEST_ORDER = "1^TAS^99VBC^^";
		private const string KC_DIVISION = "589^VA HEARTLAND - WEST, VISN 15";


		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[TearDown]
		protected void TearDown()
		{
		}

		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void SendVbecsOutboundMessage_Pass()
		{}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void SendVbecsOutboundMessage_Fail()
		{
			VbecsHL7Bridge.SendVbecsOutboundMessage(null,null, 0);
		}

		[Test]
		public void GetNextVbecsOrderNumber_Pass()
		{
			Assert.IsTrue(VbecsHL7Bridge.GetNextVbecsOrderNumber() > 0);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetNextVbecsOrderNumber_Fail()
		{}

		[Test]
		public void BuildHL7ProtocolMessage_Pass()
		{
			int orderNum = HL7ALUnitTestUtility.GetRandomNumber(9999);
			int orderGroupNum = orderNum + 1;
			string hl7Message = HL7ALUnitTestUtility.GetCprsMessage("NW",orderNum.ToString(),orderGroupNum.ToString(),TAS_TEST_ORDER,KC_DIVISION,HL7ALUnitTestUtility.GetRandomNumber(999999).ToString());

			Assert.IsNotNull(VbecsHL7Bridge.BuildHL7ProtocolMessage(hl7Message));
		}

		[Test]
		[ExpectedException( typeof ( ArgumentNullException ) )]
		public void BuildHL7ProtocolMessage_Fail()
		{
			HL7ProtocolMessage msg = VbecsHL7Bridge.BuildHL7ProtocolMessage(null);
		}

	}
}
#endif
